% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_seaice_fraction_to_freeze_seawater}
\alias{gsw_seaice_fraction_to_freeze_seawater}
\title{Sea ice Fraction to Cool Seawater to Freezing}
\usage{
gsw_seaice_fraction_to_freeze_seawater(SA, CT, p, SA_seaice, t_seaice)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{SA_seaice}{Absolute Salinity of sea ice [ g/kg ]}

\item{t_seaice}{initial temperature of sea ice [ degC ]}
}
\value{
a list containing \code{SA_freeze}, \code{CT_freeze} and \code{w_Ih}.
}
\description{
Sea ice Fraction to Cool Seawater to Freezing
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(      34.7118, 34.8915, 35.0256, 34.8472, 34.7366,  34.7324)
CT <- c(      -1.7856, -1.4329, -1.8103, -1.2600, -0.6886,   0.4403)
p <- c(            10,      50,     125,     250,     600,     1000)
SA_seaice <- c(     5,     4.8,     3.5,     2.5,       1,      0.4)
t_seaice <- c(-5.7856, -4.4329, -3.8103, -4.2600, -3.8863,  -3.4036)
r <- gsw_seaice_fraction_to_freeze_seawater(SA, CT, p, SA_seaice, t_seaice)
expect_equal(r$SA_freeze, c(34.671271207148074, 34.703449677481224, 34.950192062047861,
                          34.525277379661880, 34.077349518029997, 33.501836583274191))
expect_equal(r$CT_freeze, c(-1.895419711000293, -1.927935638317893, -1.999943183939312,
                          -2.071677444370745, -2.318866154643864, -2.603185031462614))
expect_equal(r$w_seaice, c(0.001364063868629, 0.006249283768465, 0.002391958850970,
                         0.009952101583387, 0.019541106156815, 0.035842627277027))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_seaice_fraction_to_freeze_seawater.html}
}
