% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pot_enthalpy_ice_freezing_first_derivatives_poly}
\alias{gsw_pot_enthalpy_ice_freezing_first_derivatives_poly}
\title{First Derivatives of Potential Enthalpy (Polynomial version)}
\usage{
gsw_pot_enthalpy_ice_freezing_first_derivatives_poly(SA, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing \code{pot_enthalpy_ice_freezing_SA} [ (J/kg)/(g/kg) ], the derivative of
potential enthalpy with respect to Absolute Salinity,
and \code{pot_enthalpy_ice_freezing_p} [ unitless ], the derivative of
Conservative Temperature with respect to potential temperature. (Note that the second
quantity is denoted \code{pot_enthalpy_ice_freezing_P} in the documentation for the Matlab function.)
}
\description{
First Derivatives of Potential Enthalpy (Polynomial version)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(      10,      50,     125,     250,     600,    1000)
r <- gsw_pot_enthalpy_ice_freezing_first_derivatives_poly(SA, p)
expect_equal(r$pot_enthalpy_ice_freezing_SA/1e2,
      c(-1.183498006918154, -1.184135169530602, -1.184626138334419,
      -1.184032656542549, -1.183727371435808, -1.183805326863513))
expect_equal(r$pot_enthalpy_ice_freezing_p/1e-3,
      c(-0.202934280214689, -0.203136950111241, -0.203515960539503,
      -0.204145112153220, -0.205898365024147, -0.207885289186464))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pot_enthalpy_ice_freezing_first_derivatives_poly.html}
}
