% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_latentheat_evap_CT}
\alias{gsw_latentheat_evap_CT}
\title{Latent heat of evaporation}
\usage{
gsw_latentheat_evap_CT(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
latent heat of evaporation [ J/kg ]
}
\description{
Latent heat of evaporation
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
lh  <- gsw_latentheat_evap_CT(SA, CT)
expect_equal(lh/1e6, c(2.429947107462561, 2.430774073049213, 2.444220372158452,
                     2.474127109232524, 2.482151446148560, 2.488052297193594))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_latentheat_evap_CT.html}
}
\seealso{
Other things related to latent heat: \code{\link{gsw_latentheat_evap_t}},
  \code{\link{gsw_latentheat_melting}}
}
