% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw.R
\name{read_sample_sheets}
\alias{read_sample_sheets}
\title{Read sample sheet(s)}
\usage{
read_sample_sheets(files, skip = NULL, cols = c("SampleID",
  "SentrixBarcode_A", "SentrixPosition_A"))
}
\arguments{
\item{files}{Path to sample sheet.}

\item{skip}{Integer, lines to skip, before data is read.
If not provided, the program looks for entry __[Data]__}

\item{cols}{Character vector, column names to use.}
}
\value{
A data.frame containing the idat names and the meaningful names of the samples.
}
\description{
Read one or multiple sample sheets in csv format.
The information is used to translate between cryptic names
(e.g. provided by service provider) and names that can be interpreted.
}
\examples{
if(require(brassicaData)){
samples <- read_sample_sheets(files = list.files(system.file("extdata",
package = "brassicaData"), full.names = TRUE, pattern = "csv"))
}
}

