% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gson.R
\name{gson}
\alias{gson}
\title{construct a 'GSON' object}
\usage{
gson(
  gsid2gene,
  gsid2name = NULL,
  gene2name = NULL,
  species = NULL,
  gsname = NULL,
  version = NULL,
  accessed_date = NULL,
  keytype = NULL,
  info = NULL
)
}
\arguments{
\item{gsid2gene}{A data frame with first column of gene set IDs and second column of genes}

\item{gsid2name}{A data frame with first column of gene set IDs and second column of gene set names}

\item{gene2name}{A data frame with first column of genes and second column of gene symbols}

\item{species}{Which species of the genes belongs to}

\item{gsname}{Name of the gene set (e.g., GO, KEGG, etc.)}

\item{version}{version of the gene set}

\item{accessed_date}{date to obtain the gene set data}

\item{keytype}{keytype of genes}

\item{info}{extra information}
}
\value{
A 'GSON' instance
}
\description{
construct a 'GSON' object
}
\examples{
wpfile <- system.file('extdata', "wikipathways-20220310-gmt-Homo_sapiens.gmt", package='gson')
x <- read.gmt.wp(wpfile)
gsid2gene <- data.frame(gsid=x$wpid, gene=x$gene)
gsid2name <- unique(data.frame(gsid=x$wpid, name=x$name))
species <- unique(x$species)
version <- unique(x$version)
gson(gsid2gene=gsid2gene, gsid2name=gsid2name, species=species, version=version)
}
