% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{summary.gsl_nls}
\alias{summary.gsl_nls}
\title{Model summary}
\usage{
\method{summary}{gsl_nls}(object, correlation = FALSE, symbolic.cor = FALSE, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{correlation}{logical; if \code{TRUE}, the correlation matrix of the estimated
parameters is returned and printed.}

\item{symbolic.cor}{logical; if \code{TRUE}, print the correlations in a symbolic form
(see \code{\link[stats]{symnum}}) rather than as numbers.}

\item{...}{At present no optional arguments are used.}
}
\value{
List object of class \code{"summary.nls"} identical to \code{\link[stats]{summary.nls}}
}
\description{
Returns the model summary for a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
n <- 25
xy <- data.frame(
  x = (1:n) / n,
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

summary(obj)
}
\seealso{
\code{\link[stats]{summary.nls}}
}
