% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{coef.gsl_nls}
\alias{coef.gsl_nls}
\title{Extract model coefficients}
\usage{
\method{coef}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Named numeric vector of fitted coefficients similar to \code{\link[stats]{coef}}
}
\description{
Returns the fitted model coefficients from a \code{"gsl_nls"} object.
\code{coefficients} can also be used as an alias.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n, 
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

coef(obj)
}
\seealso{
\code{\link[stats]{coef}}
}
