% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_power_wlr.R
\name{gs_power_wlr}
\alias{gs_power_wlr}
\title{Group sequential design power using weighted log rank test under non-proportional hazards}
\usage{
gs_power_wlr(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = tibble(stratum = "All", duration = c(3, 100), fail_rate = log(2)/c(9, 18),
    hr = c(0.9, 0.6), dropout_rate = rep(0.001, 2)),
  event = c(30, 40, 50),
  analysis_time = NULL,
  binding = FALSE,
  upper = gs_b,
  lower = gs_b,
  upar = gsDesign(k = 3, test.type = 1, n.I = c(30, 40, 50), maxn.IPlan = 50, sfu =
    sfLDOF, sfupar = NULL)$upper$bound,
  lpar = c(qnorm(0.1), rep(-Inf, 2)),
  test_upper = TRUE,
  test_lower = TRUE,
  ratio = 1,
  weight = wlr_weight_fh,
  info_scale = c("h0_h1_info", "h0_info", "h1_info"),
  approx = "asymptotic",
  r = 18,
  tol = 1e-06,
  interval = c(0.01, 100)
)
}
\arguments{
\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{event}{Targeted event at each analysis.}

\item{analysis_time}{Minimum time of analysis.}

\item{binding}{Indicator of whether futility bound is binding;
default of \code{FALSE} is recommended.}

\item{upper}{Function to compute upper bound.}

\item{lower}{Function to compute lower bound.}

\item{upar}{Parameters passed to \code{upper}.}

\item{lpar}{Parameters passed to \code{lower}.}

\item{test_upper}{Indicator of which analyses should include an upper
(efficacy) bound; single value of \code{TRUE} (default) indicates all analyses;
otherwise, a logical vector of the same length as \code{info} should indicate
which analyses will have an efficacy bound.}

\item{test_lower}{Indicator of which analyses should include an lower bound;
single value of \code{TRUE} (default) indicates all analyses;
single value \code{FALSE} indicated no lower bound; otherwise, a logical vector
of the same length as \code{info} should indicate which analyses will have a
lower bound.}

\item{ratio}{Experimental:Control randomization ratio (not yet implemented).}

\item{weight}{Weight of weighted log rank test:
\itemize{
\item \code{"1"} = unweighted.
\item \code{"n"} = Gehan-Breslow.
\item \code{"sqrtN"} = Tarone-Ware.
\item \code{"FH_p[a]_q[b]"} = Fleming-Harrington with p=a and q=b.
}}

\item{info_scale}{Information scale for calculation. Options are:
\itemize{
\item \code{"h0_h1_info"} (default): variance under both null and alternative hypotheses is used.
\item \code{"h0_info"}: variance under null hypothesis is used.
\item \code{"h1_info"}: variance under alternative hypothesis is used.
}}

\item{approx}{Approximate estimation method for Z statistics.
\itemize{
\item \code{"event_driven"} = only work under proportional hazard model with log rank test.
\item \code{"asymptotic"}.
}}

\item{r}{Integer value controlling grid for numerical integration as in
Jennison and Turnbull (2000); default is 18, range is 1 to 80.
Larger values provide larger number of grid points and greater accuracy.
Normally, \code{r} will not be changed by the user.}

\item{tol}{Tolerance parameter for boundary convergence (on Z-scale).}

\item{interval}{An interval that is presumed to include the time at which
expected event count is equal to targeted event.}
}
\value{
A list with input parameters, enrollment rate,
analysis, and bound.
}
\description{
Group sequential design power using weighted log rank test under non-proportional hazards
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Compute information and effect size for Weighted Log-rank test using \code{gs_info_wlr()}.
   \item Compute group sequential bound computation with non-constant effect using \code{gs_power_npe()}.
   \item Combine information and effect size and power and return a
   tibble  with columns Analysis, Bound, Time, Events, Z, Probability, AHR,  theta, info, and info0.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(gsDesign)
library(gsDesign2)

# set enrollment rates
enroll_rate <- define_enroll_rate(duration = 12, rate = 500 / 12)

# set failure rates
fail_rate <- define_fail_rate(
  duration = c(4, 100),
  fail_rate = log(2) / 15, # median survival 15 month
  hr = c(1, .6),
  dropout_rate = 0.001
)

# set the targeted number of events and analysis time
target_events <- c(30, 40, 50)
target_analysisTime <- c(10, 24, 30)

# Example 1 ----
\donttest{
# fixed bounds and calculate the power for targeted number of events
gs_power_wlr(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  event = target_events,
  analysis_time = NULL,
  upper = gs_b,
  upar = gsDesign(
    k = length(target_events),
    test.type = 1,
    n.I = target_events,
    maxn.IPlan = max(target_events),
    sfu = sfLDOF,
    sfupar = NULL
  )$upper$bound,
  lower = gs_b,
  lpar = c(qnorm(.1), rep(-Inf, 2))
)
}
# Example 2 ----
# fixed bounds and calculate the power for targeted analysis time
\donttest{
gs_power_wlr(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  event = NULL,
  analysis_time = target_analysisTime,
  upper = gs_b,
  upar = gsDesign(
    k = length(target_events),
    test.type = 1,
    n.I = target_events,
    maxn.IPlan = max(target_events),
    sfu = sfLDOF,
    sfupar = NULL
  )$upper$bound,
  lower = gs_b,
  lpar = c(qnorm(.1), rep(-Inf, 2))
)
}
# Example 3 ----
# fixed bounds and calculate the power for targeted analysis time & number of events
\donttest{
gs_power_wlr(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  event = target_events,
  analysis_time = target_analysisTime,
  upper = gs_b,
  upar = gsDesign(
    k = length(target_events),
    test.type = 1,
    n.I = target_events,
    maxn.IPlan = max(target_events),
    sfu = sfLDOF,
    sfupar = NULL
  )$upper$bound,
  lower = gs_b,
  lpar = c(qnorm(.1), rep(-Inf, 2))
)
}
# Example 4 ----
# spending bounds and calculate the power for targeted number of events
\donttest{
gs_power_wlr(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  event = target_events,
  analysis_time = NULL,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.2)
)
}
# Example 5 ----
# spending bounds and calculate the power for targeted analysis time
\donttest{
gs_power_wlr(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  event = NULL,
  analysis_time = target_analysisTime,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.2)
)
}
# Example 6 ----
# spending bounds and calculate the power for targeted analysis time & number of events
\donttest{
gs_power_wlr(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  event = target_events,
  analysis_time = target_analysisTime,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.2)
)
}
}
