% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridpts_h1_hupdate.R
\name{hupdate}
\alias{hupdate}
\title{Update numerical integration for group sequential design}
\usage{
hupdate(
  r = 18,
  theta = 0,
  info = 2,
  a = -Inf,
  b = Inf,
  thetam1 = 0,
  im1 = 1,
  gm1 = h1()
)
}
\arguments{
\item{r}{Integer, at least 2; default of 18 recommended by Jennison and Turnbull.}

\item{theta}{Drift parameter for current analysis.}

\item{info}{Information at current analysis.}

\item{a}{Lower limit of integration (scalar).}

\item{b}{Upper limit of integration (scalar \verb{> a}).}

\item{thetam1}{Drift parameter for previous analysis.}

\item{im1}{Information at previous analysis.}

\item{gm1}{Numerical integration grid from \code{\link[=h1]{h1()}} or previous run of \code{\link[=hupdate]{hupdate()}}.}
}
\value{
A list with grid points in \code{z},
numerical integration weights in \code{w},
a normal density with mean \verb{mu = theta * sqrt\{I\}}
and variance 1 times the weight in \code{h}.
}
\description{
Update grid points for numerical integration from one analysis to the next.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Compute the square root of the change in information.
   \item Compute the grid points for group sequential design numerical integration.
   \item Update the integration.
   \item Return a tibble of z, w, and h.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
# 2nd analysis with no interim bound and drift 0 should have mean 0, variance 1
g <- hupdate()
mu <- sum(g$z * g$h)
var <- sum((g$z - mu)^2 * g$h)
}
