% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_car_fit_compare_facet.R
\name{fit_compare}
\alias{fit_compare}
\title{Side-by-side plot panels that compare latent function 
values to data for different estimation models}
\usage{
fit_compare(objects, H = NULL, label.object = c("gp_rq", "gmrf_rw2"),
  units_name = "Observation_Unit", units_label = NULL, date_field = NULL,
  x.axis.label = NULL, y.axis.label = NULL)
}
\arguments{
\item{objects}{A list input where each element is a returned object
from estimation with either of \code{gpdpgrow} or 
\code{gmrfdpgrow} or an object that contains true 
\code{N x T} matrix of true latent
function values, \code{f}.  This latter input 
is only needed if want to compare 
estimated to true latent function values.}

\item{H}{An \code{N x 1} with entries in \code{1,...,M} of cluster 
assignments for the \code{N}
units of \code{y} under a known clustering.}

\item{label.object}{A character vector of length equal to \code{objects} 
that contains labels for each element of \code{objects} 
to be used in rendering comparison plots.
Defaults to \code{label.object = c("gp_rq","gmrf_rw2")}.}

\item{units_name}{A character input that provides a label 
for the set of \code{N} observation units.
Defaults to \code{units_name = "Observation_Unit"}.}

\item{units_label}{A vector of labels to apply to the observation units 
with length equal to the 
number of unique units.  Defaults to sequential 
numeric values as input with data, \code{y}.}

\item{date_field}{A vector of \code{Date} values for labeling the x-axis tick marks.
Defaults to \code{1:T}  .}

\item{x.axis.label}{Text label for x-axis. Defaults to \code{"time"}.}

\item{y.axis.label}{Text label for y-axis. Defaults to \code{"function values"}.}
}
\value{
A list object containing the plot of estimated functions, faceted by cluster,
	and the associated \code{data.frame} object.
    \item{p.t}{A \code{ggplot2} plot object}
    \item{map}{A \code{data.frame} object that contains clustering structure of
       observation units.}
}
\description{
Uses as input the output object from the gpdpgrow() and 
gmrfdpgrow() functions.
}
\examples{
{
library(growfunctions)

## load the monthly employment count data 
## for a collection of 
## U.S. states from the Current 
## Population Survey (cps)
data(cps)
## subselect the columns of N x T, y, 
## associated with 
## the years 2009 - 2013
## to examine the state level 
## employment levels 
## during the "great recession"
y_short <- cps$y[,(cps$yr_label \%in\% 
                 c(2010:2013))]

## run DP mixture of GP's to 
## estimate posterior distributions 
## for model parameters
## uses default setting of a 
## single "rational quadratic" 
## covariance formula
res_gp         <- gpdpgrow(
                     y = y_short, 
                     n.iter = 3, 
                     n.burn = 1, 
                     n.thin = 1, 
                     n.tune = 0)  
## 2 plots of estimated functions: 
## 1. faceted by cluster and fit;
## 2.  data for experimental units.
## for a group of randomly-selected 
## functions
fit_plots_gp   <- cluster_plot( 
 object = res_gp,  units_name = "state", 
 units_label = cps$st, single_unit = FALSE, 
 credible = TRUE )
                                   
## Run the DP mixture of iGMRF's to 
## estimate posterior 
## distributions for model parameters
## Under default 
## RW2(kappa) = order 2 trend 
## precision term
res_gmrf     <- gmrfdpgrow(y = y_short, 
                       n.iter = 13, 
                       n.burn = 4, 
                       n.thin = 1) 
                                     
## 2 plots of estimated functions: 
## 1. faceted by cluster and fit;
## 2.  data for experimental units.
## for a group of randomly-selected functions
fit_plots_gmrf   <- cluster_plot( object = res_gmrf, 
  units_name = "state", units_label = cps$st, 
  single_unit = FALSE, 
  credible = TRUE )                                    
                                     
## visual comparison of fit performance 
## between gpdpgrow() and gmrfdpgrow()
## or any two objects returned from any
## combination of these estimation
## functions
objects        <- vector("list",2)
objects[[1]]   <- res_gmrf
objects[[2]]   <- res_gp
label.object   <- c("gmrf_tr2","gp_rq")
## the map data.frame object 
## from fit_plots gp 
## includes a field that 
## identifies cluster assignments
## for each unit (or domain)
H        <- fit_plots_gp$map$cluster
fit_plot_compare_facet <- 
fit_compare( objects = objects, 
 H = H, label.object = label.object,
 y.axis.label = "normalized y",
 units_name = "state", units_label = cps$st)                                  
}
}
\author{
Terrance Savitsky \email{tds151@gmail.com}
}
\seealso{
\code{\link{gpdpgrow}}, \code{\link{gmrfdpgrow}}
}

