% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_value_remaining.R
\name{estimate_value_remaining}
\alias{estimate_value_remaining}
\title{Estimate Value Remaining}
\usage{
estimate_value_remaining(
  input_df,
  distribution,
  priors = list(),
  wrt_option = NULL,
  metric = "lift",
  threshold = 0.95
)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str) and various other columns
depending on the distribution type. See vignette for more details.}

\item{distribution}{String of the distribution name}

\item{priors}{Optional list of priors. Defaults will be use otherwise.}

\item{wrt_option}{string the option loss is calculated with respect to (wrt). If NULL, the best option will be chosen.}

\item{metric}{string the type of loss.
absolute will be the difference, on the outcome scale. 0 when best = wrt_option
lift will be the (best - wrt_option) / wrt_option, 0 when best = wrt_option
relative_risk will be the ratio best/wrt_option, 1 when best = wrt_option}

\item{threshold}{The confidence interval specifying what the "worst case scenario should be.
Defaults to 95\%. (optional)}
}
\value{
numeric value remaining at the specified threshold
}
\description{
Estimates value remaining or loss (in terms of percent lift, absolute, or relative).
}
\examples{
input_df <- tibble::tibble(option_name = c("A", "B", "C"),
    sum_clicks = c(1000, 1000, 1000),
    sum_conversions = c(100, 120, 110))
estimate_value_remaining(input_df, distribution = "conversion_rate")
estimate_value_remaining(input_df,
    distribution = "conversion_rate",
    threshold = 0.99)
estimate_value_remaining(input_df,
    distribution = "conversion_rate",
    wrt_option = "A",
    metric = "absolute")

}
