% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_win_prob_vs_baseline.R
\name{estimate_win_prob_vs_baseline}
\alias{estimate_win_prob_vs_baseline}
\title{Estimate Win Probability vs. Baseline}
\usage{
estimate_win_prob_vs_baseline(
  input_df,
  distribution,
  priors = list(),
  wrt_option
)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str) and various other columns
depending on the distribution type. See vignette for more details.}

\item{distribution}{String of the distribution name}

\item{priors}{Optional list of priors. Defaults will be use otherwise.}

\item{wrt_option}{string the option win prob is calculated with respect to (wrt). Required.}
}
\value{
Tibble of each option_name and the win probability expressed as a percentage and a decimal `raw`
}
\description{
Calculates the win probability of the best option compared to a single other option
given an input_df
}
\examples{
input_df <- tibble::tibble(
    option_name = c("A", "B", "C"),
    sum_clicks = c(1000, 1000, 1000),
    sum_conversions = c(100, 120, 110)
)
estimate_win_prob_vs_baseline(input_df = input_df,
    distribution = "conversion_rate",
    wrt_option = "B")

}
