% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_lift.R
\name{estimate_lift}
\alias{estimate_lift}
\title{Estimate Lift Distribution}
\usage{
estimate_lift(
  posterior_samples,
  distribution,
  wrt_option,
  metric = c("absolute", "lift", "relative_risk")
)
}
\arguments{
\item{posterior_samples}{Tibble returned from sample_from_posterior with 3 columns
`option_name`, `samples`, and `sample_id`.}

\item{distribution}{String of the distribution name}

\item{wrt_option}{string the option lift is calculated with respect to (wrt). Required.}

\item{metric}{string the type of lift.
absolute will be the difference, on the outcome scale. 0 when best = wrt_option
lift will be the (best - wrt_option) / wrt_option, 0 when best = wrt_option
relative_risk will be the ratio best/wrt_option, 1 when best = wrt_option}
}
\value{
numeric, the lift distribution
}
\description{
Estimates lift distribution vector from posterior samples.
}
\examples{
# Requires posterior_samples dataframe. See `sample_from_posterior()`
# for an example.

\donttest{
estimate_lift(posterior_samples = posterior_samples,
              distribution = "conversion_rate",
              wrt_option = "A",
              metric = "lift")
}

}
