% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_guess_has_R4.1_features_docs.R
\name{guess_has_R4.1_features}
\alias{guess_has_R4.1_features}
\title{Guess whether "active" graphics device supports
the grid graphics features introduced in R v4.1.}
\usage{
guess_has_R4.1_features(
  features = c("clippingPaths", "gradients", "masks", "patterns")
)
}
\arguments{
\item{features}{Character vector of features to guess support for.
Will return \code{TRUE} only if guesses support for all requested features.\describe{
\item{"clippingPaths"}{Supports clipping path feature}
\item{"gradients"}{Supports (both linear and radial) gradient feature}
\item{"masks"}{Supports (alpha) mask feature}
\item{"patterns"}{Supports (tiling) pattern feature}
}}
}
\value{
\code{TRUE} if we guess all \code{features} are supported else \code{FALSE}
}
\description{
\code{guess_has_R4.1_features()} guesses whether "active" graphics device supports
the grid graphics features introduced in R v4.1.  If it guesses it does
it returns \code{TRUE} else \code{FALSE}.
}
\section{Usage in other packages}{


To avoid taking a dependency on \code{gridpattern} you may copy the source of \code{guess_has_R4.1_features()}
into your own package under the permissive MIT No Attribution (MIT-0) license.  Either use
\code{usethis::use_standalone("trevorld/gridpattern", "standalone-guess_has_R4.1_features.R")}
or copy the file \code{standalone-guess_has_R4.1_features.R} into your \code{R} directory and
add \code{grDevices} and \code{utils} to the \code{Imports} of your \code{DESCRIPTION} file.
}

\examples{
  # If R version (weakly) greater than 4.1 should be TRUE
  pdf(tempfile(fileext = ".pdf"))
  print(guess_has_R4.1_features())
  invisible(dev.off())

  # Should be FALSE
  postscript(tempfile(fileext = ".ps"))
  print(guess_has_R4.1_features())
  invisible(dev.off())

}
\seealso{
\url{https://www.stat.auckland.ac.nz/~paul/Reports/GraphicsEngine/definitions/definitions.html} for more info about the new grid graphics
features introduced in R v4.1.
}
