% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_forest.R
\name{regression_forest}
\alias{regression_forest}
\title{Regression forest}
\usage{
regression_forest(X, Y, sample.fraction = 0.5, mtry = ceiling(2 *
  ncol(X)/3), num.trees = 2000, num.threads = NULL, min.node.size = NULL,
  honesty = TRUE, ci.group.size = 2, alpha = 0.05, lambda = 0,
  downweight.penalty = FALSE, seed = NULL)
}
\arguments{
\item{X}{The covariates used in the regression.}

\item{Y}{The outcome.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty is used, these subsamples will
further be cut in half.}

\item{mtry}{Number of variables tried for each split.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{min.node.size}{Minimum number of observations in each tree leaf.}

\item{honesty}{Should honest splitting (i.e., sub-sample splitting) be used?}

\item{ci.group.size}{The forest will grow ci.group.size trees on each subsample.
In order to provide confidence intervals, ci.group.size must
be at least 2.}

\item{alpha}{Maximum imbalance of a split.}

\item{lambda}{A tuning parameter to control the amount of split regularization (experimental).}

\item{downweight.penalty}{Whether or not the regularization penalty should be downweighted (experimental).}

\item{seed}{The seed of the c++ random number generator.}
}
\value{
A trained regression forest object.
}
\description{
Trains a regression forest that can be used to estimate
the conditional mean function mu(x) = E[Y | X = x]
}
\examples{
# Train a standard regression forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
Y = X[,1] * rnorm(n)
r.forest = regression_forest(X, Y)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
r.pred = predict(r.forest, X.test)

# Predict on out-of-bag training samples.
r.pred = predict(r.forest)

# Predict with confidence intervals; growing more trees is now recommended.
r.forest = regression_forest(X, Y, num.trees = 100)
r.pred = predict(r.forest, X.test, estimate.variance = TRUE)

}
