% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_forest.R
\name{predict.quantile_forest}
\alias{predict.quantile_forest}
\title{Predict with a quantile forest}
\usage{
\method{predict}{quantile_forest}(object, newdata = NULL, quantiles = c(0.1,
  0.5, 0.9), num.threads = NULL, ...)
}
\arguments{
\item{object}{The trained forest.}

\item{newdata}{Points at which predictions should be made. If NULL,
makes out-of-bag predictions on the training set instead
(i.e., provides predictions at Xi using only trees that did
not use the i-th training example).}

\item{quantiles}{Vector of quantiles at which estimates are required.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Predictions for each test point and each desired quantile.
}
\description{
Gets estimates of the conditional quantiles of Y given X using a trained forest.
}
