% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnorm.R
\name{dfnorm}
\alias{dfnorm}
\alias{pfnorm}
\alias{qfnorm}
\alias{rfnorm}
\title{Folded Normal Distribution}
\usage{
dfnorm(q, mu = 0, sigma = 1, log = FALSE)

pfnorm(q, mu = 0, sigma = 1)

qfnorm(p, mu = 0, sigma = 1)

rfnorm(n = 1, mu = 0, sigma = 1)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{vector of location parameters (means).}

\item{sigma}{vector of scale parameters.}

\item{log}{if \code{TRUE}, then probabilities are returned in
logarithms.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. Should be a single number.}
}
\value{
Depending on the function, various things are returned
(usually either vector or scalar):
\itemize{
\item \code{dfnorm} returns the density function value for the
provided parameters.
\item \code{pfnorm} returns the value of the cumulative function
for the provided parameters.
\item \code{qfnorm} returns quantiles of the distribution. Depending
on what was provided in \code{p}, \code{mu} and \code{sigma}, this
can be either a vector or a matrix, or an array.
\item \code{rfnorm} returns a vector of random variables
generated from the fnorm distribution. Depending on what was
provided in \code{mu} and \code{sigma}, this can be either a vector
or a matrix or an array.
}
}
\description{
Density, cumulative distribution, quantile functions and random number
generation for the folded normal distribution with the location
parameter mu and the scale sigma (which corresponds to standard
deviation in normal distribution).
}
\details{
The distribution has the following density function:

f(x) = 1/sqrt(2 pi) (exp(-(x-mu)^2 / (2 sigma^2)) + exp(-(x+mu)^2 / (2 sigma^2)))

Both \code{pfnorm} and \code{qfnorm} are returned for the lower
tail of the distribution.
}
\examples{
x <- dfnorm(c(-1000:1000)/200, 0, 1)
plot(x, type="l")

x <- pfnorm(c(-1000:1000)/200, 0, 1)
plot(x, type="l")

qfnorm(c(0.025,0.975), 0, c(1,2))

x <- rfnorm(1000, 0, 1)
hist(x)

}
\references{
\itemize{
\item Wikipedia page on folded normal distribution:
\url{https://en.wikipedia.org/wiki/Folded_normal_distribution}.
}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{distribution}
