% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svet.R
\name{ds}
\alias{ds}
\alias{ps}
\alias{qs}
\alias{rs}
\title{S Distribution}
\usage{
ds(q, mu = 0, b = 1, log = FALSE)

ps(q, mu = 0, b = 1)

qs(p, mu = 0, b = 1)

rs(n = 1, mu = 0, b = 1)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{vector of location parameters (means).}

\item{b}{vector of scaling parameter (which are equal to ham/2).}

\item{log}{if \code{TRUE}, then probabilities are returned in
logarithms.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. Should be a single number.}
}
\value{
Depending on the function, various things are returned
(usually either vector or scalar):
\itemize{
\item \code{ds} returns the density function value for the
provided parameters.
\item \code{ps} returns the value of the cumulative function
for the provided parameters.
\item \code{qs} returns quantiles of the distribution. Depending
on what was provided in \code{p}, \code{mu} and \code{b}, this
can be either a vector or a matrix, or an array.
\item \code{rs} returns a vector of random variables
generated from the S distribution. Depending on what was provided
in \code{mu} and \code{b}, this can be either a vector or a matrix
or an array.
}
}
\description{
Density, cumulative distribution, quantile functions and random
generation for the S distribution with the location parameter mu
and a scaling parameter b.
}
\details{
When mu=0 and ham=2, the S distribution becomes standardized with
b=1 (this is because b=ham/2). The distribution has the following
density function:

f(x) = 1/(4b^2) exp(-sqrt(abs(x-mu)) / b)

The S distribution has fat tails and large excess.

Both \code{ps} and \code{qs} are returned for the lower tail of
the distribution.
}
\examples{
x <- ds(c(-1000:1000)/10, 0, 1)
plot(x, type="l")

x <- ps(c(-1000:1000)/10, 0, 1)
plot(x, type="l")

qs(c(0.025,0.975), 0, 1)

x <- rs(1000, 0, 1)
hist(x)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{distribution}
