% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_avg_tax_rates.R
\name{compare_avg_tax_rates}
\alias{compare_avg_tax_rates}
\title{Compare average tax rates by percentile}
\usage{
compare_avg_tax_rates(DT, baseDT, by = "id", ids = NULL)
}
\arguments{
\item{DT}{A single \code{data.table} containing columns \code{new_tax},
\code{Taxable_Income}, \code{baseline_tax}.}

\item{baseDT}{A \code{data.table} of a single cross-section of taxpayers from
which baseline percentiles can be produced.}

\item{by}{How to separate \code{DT}}

\item{ids}{Subset \code{DT} by \code{by}.}
}
\description{
To determine the effects of bracket creep on a proposed tax policy,
a common task is calculate the change in the average tax rates for each percentile.
This function accepts a sample file and a baseline sample file, and returns a 100-row table
giving the mean change in average tax rates for each percentile, compared to the baseline.
}
