% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-smooths.R
\name{compare_smooths}
\alias{compare_smooths}
\title{Compare smooths across models}
\usage{
compare_smooths(
  model,
  ...,
  smooths = NULL,
  n = 100,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE
)
}
\arguments{
\item{model}{Primary model for comparison.}

\item{...}{Additional models to compare smooths against those of \code{model}.}

\item{smooths}{character; vector of smooths to compare. If not specified
comparisons will be performed for smooths common to all models supplied.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{data}{a data frame of covariate values at which to evaluate the
smooth.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}
}
\description{
Compare smooths across models
}
\examples{
\dontshow{op <- options(cli.unicode = FALSE, pillar.sigfig = 5)}
load_mgcv()
dat <- data_sim("eg1", seed = 2)

## models to compare smooths across - artificially create differences
m1 <- gam(y ~ s(x0, k = 5) + s(x1, k = 5) + s(x2, k = 5) + s(x3, k = 5),
          data = dat, method = "REML")
m2 <- gam(y ~ s(x0, bs = 'ts') + s(x1, bs = 'ts') + s(x2, bs = 'ts') +
          s(x3, bs = 'ts'), data = dat, method = "REML")

## build comparisons
comp <- compare_smooths(m1, m2)
comp
## notice that the result is a nested tibble

draw(comp)
\dontshow{options(op)}
}
