% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis-funs.R
\name{basis}
\alias{basis}
\title{Basis expansions for smooths}
\usage{
basis(smooth, data, knots = NULL, constraints = FALSE, ...)
}
\arguments{
\item{smooth}{a smooth specification, the result of a call to one of
\code{\link[mgcv:s]{mgcv::s()}}., \code{\link[mgcv:te]{mgcv::te()}}, \code{\link[mgcv:te]{mgcv::ti()}}, or \code{\link[mgcv:t2]{mgcv::t2()}}.}

\item{data}{a data frame containing the variables used in \code{smooth}.}

\item{knots}{a list or data frame with named components containing
knots locations. Names must match the covariates for which the basis
is required. See \code{\link[mgcv:smoothCon]{mgcv::smoothCon()}}.}

\item{constraints}{logical; should identifiability constraints be applied to
the smooth basis. See argument \code{absorb.cons} in \code{\link[mgcv:smoothCon]{mgcv::smoothCon()}}.}

\item{...}{other arguments passed to \code{\link[mgcv:smoothCon]{mgcv::smoothCon()}}.}
}
\value{
A tibble.
}
\description{
Creates a basis expansion from a definition of a smoother using the syntax
of \emph{mgcv}'s smooths via \code{\link[mgcv:s]{mgcv::s()}}., \code{\link[mgcv:te]{mgcv::te()}}, \code{\link[mgcv:te]{mgcv::ti()}}, and
\code{\link[mgcv:t2]{mgcv::t2()}}.
}
\examples{
load_mgcv()
\dontshow{
set.seed(42)
op <- options(digits = 3, cli.unicode = FALSE)
}
df <- gamSim(4, n = 400, verbose = FALSE)

bf <- basis(s(x0), data = df)
bf <- basis(s(x2, by = fac, bs = 'bs'), data = df, constraints = TRUE)
\dontshow{options(op)}
}
\author{
Gavin L. Simpson
}
