% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{qq_plot}
\alias{qq_plot}
\alias{qq_plot.gam}
\title{Quantile-quantile plot of model residuals}
\usage{
qq_plot(model, ...)

\method{qq_plot}{gam}(model, method = c("direct", "simulate", "normal"),
  type = c("deviance", "response", "pearson"), n_uniform = 10,
  n_simulate = 50, level = 0.9, ylab = NULL, xlab = NULL,
  title = NULL, subtitle = NULL, caption = NULL, alpha = 0.2, ...)
}
\arguments{
\item{model}{a fitted model. Currently only class \code{"gam"}.}

\item{...}{arguments passed ot other methods.}

\item{method}{character; method used to generate theoretical quantiles.}

\item{type}{character; type of residuals to use. Only \code{"deviance"},
\code{"response"}, and \code{"pearson"} residuals are allowed.}

\item{n_uniform}{numeric; number of times to randomize uniform quantiles
in the direct computation method (\code{method = "direct"}).}

\item{n_simulate}{numeric; number of data sets to simulate from the estimated
model when using the simulation method (\code{method = "simulate"}).}

\item{level}{numeric; the coverage level for reference intervals. Must be
strictly \code{0 < level < 1}. Only used with \code{method = "simulate"}.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{xlab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{alpha}{numeric; the level of alpha transparency for the reference
interval when \code{method = "simulate"}.}
}
\description{
Quantile-quantile plot of model residuals
}
\examples{
suppressPackageStartupMessages(library("mgcv"))
## simulate binomial data...
set.seed(0)
n.samp <- 200
dat <- gamSim(1, n = n.samp, dist = "binary", scale = .33)
p <- binomial()$linkinv(dat$f)               # binomial p
n <- sample(c(1, 3), n.samp, replace = TRUE) # binomial n
dat <- transform(dat, y = rbinom(n, n, p), n = n)
m <- gam( y / n ~ s(x0) + s(x1) + s(x2) + s(x3),
         family = binomial, data = dat, weights = n,
         method = "REML")

## Q-Q plot; default using direct randomization of uniform quantiles
qq_plot(m)

## Alternatively use simulate new data from the model, which
## allows construction of reference intervals for the Q-Q plot
qq_plot(m, method = "simulate")

## ... or use the usual normality assumption
qq_plot(m, method = "normal")
}
