% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-helpers.R
\name{has_theta}
\alias{has_theta}
\title{Are additional parameters available for a GAM?}
\usage{
has_theta(object)
}
\arguments{
\item{object}{an R object, either a \code{\link[=family]{family()}} object or an object whose
class has a \code{\link[=family]{family()}} method.}
}
\value{
A logical; \code{TRUE} if additional parameters available, \code{FALSE}
otherwise.
}
\description{
Are additional parameters available for a GAM?
}
\examples{
load_mgcv()
df <- data_sim("eg1", dist = "poisson", seed = 42, scale = 1 / 5)
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3),
  data = df, method = "REML",
  family = nb()
)
has_theta(m)
p <- theta(m)
}
