% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearquarter.R
\name{as_yearquarter}
\alias{as_yearquarter}
\alias{as_yearquarter.default}
\alias{as_yearquarter.Date}
\alias{as_yearquarter.POSIXt}
\alias{as_yearquarter.character}
\alias{as_yearquarter.factor}
\title{Coerce an object to year-quarter}
\usage{
as_yearquarter(x, ...)

\method{as_yearquarter}{default}(x, ...)

\method{as_yearquarter}{Date}(x, ...)

\method{as_yearquarter}{POSIXt}(x, ...)

\method{as_yearquarter}{character}(x, ...)

\method{as_yearquarter}{factor}(x, ...)
}
\arguments{
\item{x}{\R object}

\item{...}{Only used For character input where additional arguments are passed through
to \code{as.Date()}.}
}
\value{
A \verb{<grates_yearquarter>} object.
}
\description{
\code{as_yearquarter()} is a generic for coercing input in to \verb{<grates_yearquarter>}.
Character input is first parsed using \code{as.Date()}. POSIXct and POSIXlt are
all converted, with the timezone respected.
}
\note{
Internally \verb{<grates_yearquarter>} objects are stored as the number of
quarters (starting at 0) since the Unix Epoch (1970-01-01).
}
\examples{
as_yearquarter(Sys.Date())
as_yearquarter(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"), interval = 2)
as_yearquarter("2019-05-03")

}
\seealso{
\code{as.Date()}
}
