% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_graphs.R
\name{bonferroni}
\alias{bonferroni}
\alias{bonferroni_holm}
\alias{huque_etal}
\alias{fallback}
\alias{fallback_improved_1}
\alias{fallback_improved_2}
\alias{fixed_sequence}
\alias{simple_successive_1}
\alias{simple_successive_2}
\alias{random_graph}
\alias{two_doses_two_primary_two_secondary}
\alias{three_doses_two_primary_two_secondary}
\title{Example graphs of commonly used multiple comparison procedures}
\usage{
bonferroni(hypotheses, hyp_names = NULL)

bonferroni_holm(hypotheses, hyp_names = NULL)

huque_etal(hyp_names = NULL)

fallback(hypotheses, hyp_names = NULL)

fallback_improved_1(hypotheses, hyp_names = NULL)

fallback_improved_2(hypotheses, epsilon = 1e-04, hyp_names = NULL)

fixed_sequence(num_hyps, hyp_names = NULL)

simple_successive_1(hyp_names = NULL)

simple_successive_2(hyp_names = NULL)

random_graph(num_hyps, hyp_names = NULL)

two_doses_two_primary_two_secondary(hyp_names = NULL)

three_doses_two_primary_two_secondary(hyp_names = NULL)
}
\arguments{
\item{hypotheses}{(Optional) A numeric vector of hypothesis weights in a
graphical multiple comparison procedure. Must be a vector of values
between 0 & 1 (inclusive). The length should match \code{num_hyps} and the
length of \code{hyp_names}. The sum of hypothesis weights should not exceed 1.}

\item{hyp_names}{(Optional) A character vector of hypothesis names. The
length should match \code{num_hyps} and the length of \code{hypotheses}. If
\code{hyp_names} are not specified, hypotheses will be named sequentially as
H1, H2, .......}

\item{epsilon}{(Optional) A numeric scalar indicating the value of the
\eqn{\epsilon} edge. This should be a much smaller value than hypothesis
and transition weights. The default is 1e-4.}

\item{num_hyps}{(Optional) Number of hypotheses in a graphical multiple
comparison procedure.}
}
\value{
An S3 object as returned by \code{\link[=graph_create]{graph_create()}}.
}
\description{
Built-in functions to quickly generate select graphical multiple comparison
procedures.
}
\examples{
# Bretz et al. (2009)
bonferroni(hypotheses = rep(1 / 3, 3))
# Bretz et al. (2009)
bonferroni_holm(hypotheses = rep(1 / 3, 3))
# Huque et al. (2011)
huque_etal()
# Wiens (2003)
fallback(hypotheses = rep(1 / 3, 3))
# Wiens and Dmitrienko (2005)
fallback_improved_1(hypotheses = rep(1 / 3, 3))
# Bretz et al. (2009)
fallback_improved_2(hypotheses = rep(1 / 3, 3))
# Maurer et al. (1995); Westfall and Krishen (2001)
fixed_sequence(num_hyps = 3)
# Figure 1 in Bretz et al. (2011)
simple_successive_1()
# Figure 4 in Bretz et al. (2011)
simple_successive_2()
# Create a random graph with three hypotheses
random_graph(num_hyps = 3)
# Figure 6 in Xi and Bretz et al. (2019)
two_doses_two_primary_two_secondary()
# Add another dose to Figure 6 in Xi and Bretz et al. (2019)
three_doses_two_primary_two_secondary()
}
\references{
Bretz, F., Maurer, W., Brannath, W., and Posch, M. (2009). A graphical
approach to sequentially rejective multiple test procedures.
\emph{Statistics in Medicine}, 28(4), 586-604.

Bretz, F., Posch, M., Glimm, E., Klinglmueller, F., Maurer, W., and
Rohmeyer, K. (2011). Graphical approaches for multiple comparison
procedures using weighted Bonferroni, Simes, or parametric tests.
\emph{Biometrical Journal}, 53(6), 894-913.

Huque, M. F., Alosh, M., and Bhore, R. (2011). Addressing multiplicity
issues of a composite endpoint and its components in clinical trials.
\emph{Journal of Biopharmaceutical Statistics}, 21(4), 610-634.

Maurer, W., Hothorn, L., and Lehmacher, W. (1995). Multiple comparisons in
drug clinical trials and preclinical assays: a-priori ordered hypotheses.
\emph{Biometrie in der chemisch-pharmazeutischen Industrie}, 6, 3-18.

Westfall, P. H., and Krishen, A. (2001). Optimally weighted, fixed sequence
and gatekeeper multiple testing procedures.
\emph{Journal of Statistical Planning and Inference}, 99(1), 25-40.

Wiens, B. L. (2003). A fixed sequence Bonferroni procedure for testing
multiple endpoints. \emph{Pharmaceutical Statistics}, 2(3), 211-215.

Wiens, B. L., and Dmitrienko, A. (2005). The fallback procedure for
evaluating a single family of hypotheses.
\emph{Journal of Biopharmaceutical Statistics}, 15(6), 929-942.

Xi, D., and Bretz, F. (2019). Symmetric graphs for equally weighted tests,
with application to the Hochberg procedure. \emph{Statistics in Medicine},
38(27), 5268-5282.
}
\seealso{
\code{\link[=graph_create]{graph_create()}} for a general way to create the initial graph.
}
