% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_connected_components.R
\name{gf_connected_components}
\alias{gf_connected_components}
\title{Connected components}
\usage{
gf_connected_components(x, broadcast_threshold = 1000000L,
  algorithm = c("graphframes", "graphx"), checkpoint_interval = 2L, ...)
}
\arguments{
\item{x}{An object coercable to a GraphFrame (typically, a
\code{gf_graphframe}).}

\item{broadcast_threshold}{Broadcast threshold in propagating component assignments.}

\item{algorithm}{One of 'graphframes' or 'graphx'.}

\item{checkpoint_interval}{Checkpoint interval in terms of number of iterations.}

\item{...}{Optional arguments, currently not used.}
}
\description{
Computes the connected component membership of each vertex and returns a DataFrame
   of vertex information with each vertex assigned a component ID.
}
\examples{
\dontrun{
# checkpoint directory is required for gf_connected_components()
spark_set_checkpoint_dir(sc, tempdir())
g <- gf_friends(sc)
gf_connected_components(g)
}
}
