% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaf.R
\name{pspaf_discrete}
\alias{pspaf_discrete}
\title{Internal, pathway specific PAF when the mediator is discrete}
\usage{
pspaf_discrete(
  data,
  refval,
  riskfactor_col,
  mediator_col,
  mediator_model,
  response_model,
  weight_vec
)
}
\arguments{
\item{data}{dataframe. A dataframe (with no missing values) containing the data used to fit the mediator and response models.  You can run data_clean to the input dataset if the data has missing values as a pre-processing step}

\item{refval}{For factor valued risk factors, the reference level of the risk factor.  If the risk factor is numeric, the reference level is assumed to be 0}

\item{riskfactor_col}{Integer indicator for the risk factor column in data}

\item{mediator_col}{Integer indicator for the discrete mediator column in data}

\item{mediator_model}{A glm or polr model for the mediator, depending on the same confounders and risk factor as specified in the response model.}

\item{response_model}{A R model object for a binary outcome that involves a risk factor, confounders and mediators of the risk factor outcome relationship.  Note that a weighted model should be used for case control data.  Non-linear effects should be specified via ns(x, df=y), where ns is the natural spline function from the splines library.}

\item{weight_vec}{A numeric column of weights}
}
\value{
A numeric vector (if ci=FALSE), or data frame (if CI=TRUE) containing estimated PS-PAF for each mediator referred to in mediator_models, together with estimated direct PS-PAF and possibly confidence intervals.
}
\description{
Internal, pathway specific PAF when the mediator is discrete
}
