% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_graph_topo.R
\name{gen_graph_topo}
\alias{gen_graph_topo}
\title{Create a graph of genetic differentiation with
a specific topology}
\usage{
gen_graph_topo(mat_w, mat_topo = NULL, topo = "gabriel")
}
\arguments{
\item{mat_w}{A symmetric (pairwise) \code{matrix} whose elements
will be the links' weights}

\item{mat_topo}{(optional) A symmetric (pairwise) distance \code{matrix}
whose values will be used for the pruning method.}

\item{topo}{Which topology does the created graph have?
\itemize{
\item{If 'topo = 'gabriel'' (default), the resulting graph will be a Gabriel graph
(Gabriel et al., 1969). It means that there is a link between nodes x and y
if and only if \eqn{d_{xy}^{2} \leq \min(\sqrt{d_{xz}^{2}+d_{yz}^{2}}) },
with z any other node of the graph.}
\item{If 'topo = 'mst'', the resulting graph will have the topology
of a minimum spanning tree. It means that the graph will not include
any cycle (tree) and it will be the subgraph with a tree topology with
the minimum total links' weight (based on 'mat_topo' values).}
\item{If 'topo = 'percol'', if the link of the resulting graph with the
minimum weight is removed, then the graph breaks into two components.}
\item{If 'topo = 'comp'', a complete graph whose links are weighted with
values from 'mat_w' is created.}
}}
}
\value{
A graph object of class \code{igraph}
}
\description{
The function allows to construct a genetic graph with
a specific topology from genetic and/or geographical distance matrices
}
\details{
If 'mat_topo' is not defined, 'mat_w' is used for the pruning.
Matrices 'mat_w' and 'mat_topo' must have the same dimensions and the
same rows' and columns' names.
Values in 'mat_topo' matrix must be positive. Negative values from
'mat_w' are transformed into zeros.
The function works only for undirected graphs.
}
\examples{
mat_w <- mat_gen_dist(x = data_simul_genind, dist = 'DPS')
suppressWarnings(mat_topo <- mat_geo_dist(pts_pop_simul,
                 ID = "ID",
                 x = "x",
                y = "y"))
mat_topo <- mat_topo[row.names(mat_w), colnames(mat_w)]
graph <- gen_graph_topo(mat_w, mat_topo, topo = "mst")
}
\references{
\insertRef{gabriel1969new}{graph4lg}
}
\author{
P. Savary
}
