% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{as.Seurat.grandR}
\alias{as.Seurat.grandR}
\title{Create Seurat object from a grandR object}
\usage{
as.Seurat.grandR(
  data,
  modalities = c(RNA = "total", newRNA = "new"),
  hls = NULL,
  time = NULL,
  mode = c("assay", "cells", "genes", "list")
)
}
\arguments{
\item{data}{a grandR object}

\item{modalities}{vector defining modalities to include in the Seurat object (see details)}

\item{hls}{half-lives for computing previous RNA, only required for "prev" modality (see details)}

\item{time}{labeling time, only required for "prev" modality (see details)}

\item{mode}{how to integrate modalities into seurat object (see details)}
}
\value{
a Seurat object
}
\description{
Create Seurat object from a grandR object
}
\details{
Modalities must be a named character vector. The only allowed elements are "total" (total counts),
"new" (new counts), "old" (old counts), "prev" (estimated previous time point counts). The names of the elements are further
used depending on mode.

To compute the previous time point counts, a vector of half lives and the labeling time is required. The half-lives
must be given in the correct order (same as in the grandR object).

The mode parameter defines how the defined modalities are represented in the Seurat object. "assay" means
that for each modality, the Seurat object will contain an assay (named according to the corresponding name in modalities).
"cells" means that cells will be copied for each modality and cell names are prefixed by the corresponding name in modalities
 (i.e., if the grandR object has 1000 cells named c1,...,c1000, and modalities=c(RNA="total",newRNA="new"), the Seurat object
 will have 2000 cells named RNA.c1,...,RNA.c1000,newRNA.c1,...,newRNA.c1000). "genes" means that genes fill be copied for each
 modality and gene names are prefixed by the corresponding name in modalities. "list" means that instead of a single Seurat object,
 a list of Seurat objects is returned.
}
\concept{load}
