#' List of palettes available in grafify package
#' 
#' To visualise these colours use \code{plot_grafify_palette}.
#' @return This function returns a list of palettes in grafify with names and hexcodes of colours in those  palettes.
#'  
#' @export
#' 
graf_palettes <- list(
  'okabe_ito' = get_graf_colours("ok_orange",
                                 "ok_skyblue",
                                 "ok_bluegreen",
                                 "ok_yellow",
                                 "ok_blue",
                                 "ok_vermillion",
                                 "ok_redpurple",
                                 "ok_grey"),
  'bright' = get_graf_colours( "bright_blue",
                               "bright_cyan",
                               "bright_green",
                               "bright_yellow",
                               "bright_red",
                               "bright_purple",
                               "bright_grey"),
  'pale' = get_graf_colours( "pale_blue",
                             "pale_cyan",
                             "pale_green",
                             "pale_yellow",
                             "pale_red",
                             "pale_grey"),
  'muted' = get_graf_colours("muted_indigo",
                             "muted_cyan",
                             "muted_teal",
                             "muted_green",
                             "muted_oliver",
                             "muted_sand",
                             "muted_rose",
                             "muted_wine",
                             "muted_purple",
                             "pale_grey"),
  'light' = get_graf_colours(  "light_blue",
                               "light_cyan",
                               "light_mint",
                               "light_pear",
                               "light_olive",
                               "light_yellow",
                               "light_orange",
                               "light_pink",
                               "pale_grey"),
  'dark' = get_graf_colours(  "dark_blue",
                              "dark_cyan",
                              "dark_green",
                              "dark_yellow",
                              "dark_red",
                              "dark_grey"),
  'contrast' = get_graf_colours("contrast_white",
                                "contrast_yellow",
                                "contrast_red",
                                "contrast_blue",
                                "contrast_black"),
  'vibrant' = get_graf_colours("vibrant_blue",
                               "vibrant_cyan",
                               "vibrant_teal",
                               "vibrant_orange",
                               "vibrant_red",
                               "vibrant_magenta",
                               "bright_grey"),
  'yellow_conti' = get_graf_colours("YlOrBr_1", 
                                    "YlOrBr_2",
                                    "YlOrBr_3",
                                    "YlOrBr_4",
                                    "YlOrBr_5",
                                    "YlOrBr_6",
                                    "YlOrBr_7",
                                    "YlOrBr_8",
                                    "YlOrBr_9"),
  'all_grafify' = get_graf_colours("ok_orange",
    "ok_skyblue",
    "ok_bluegreen",
    "ok_yellow",
    "ok_blue",
    "ok_vermillion",
    "ok_redpurple",
    "muted_indigo",
    "muted_cyan",
    "muted_teal",
    "muted_green",
    "muted_oliver",
    "muted_sand",
    "muted_rose",
    "muted_wine",
    "muted_purple",
    "light_blue",
    "light_cyan",
    "light_mint",
    "light_pear",
    "light_olive",
    "light_yellow",
    "light_orange",
    "light_pink",
    "pale_blue",
    "pale_cyan",
    "pale_green",
    "pale_yellow",
    "pale_red",
    "pale_grey",
    "dark_grey",
    "bright_grey",
    "ok_grey",
    "contrast_white",
    "contrast_yellow",
    "contrast_red",
    "contrast_blue",
    "contrast_black",
    "vibrant_blue",
    "vibrant_cyan",
    "vibrant_teal",
    "vibrant_orange",
    "vibrant_red",
    "vibrant_magenta",
    "dark_blue",
    "dark_cyan",
    "dark_green",
    "dark_yellow",
    "dark_red",
    "bright_blue",
    "bright_cyan",
    "bright_green",
    "bright_yellow",
    "bright_red",
    "bright_purple"
  ))
