% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dti.R
\name{dti}
\alias{dti}
\title{Estimation of Drought Tolerance Indices.}
\usage{
dti(data, environment, genotype, traits, ns, st)
}
\arguments{
\item{data}{dataframe containing following variables}

\item{environment}{column with two levels i.e., non-stress and stress conditions}

\item{genotype}{genotypes evaluated}

\item{traits}{trait of interest}

\item{ns}{name of level indicating evaluation under non-stress (irrigated) conditions}

\item{st}{name of level indicating evaluation under stress conditions}
}
\value{
\item{\code{TOL}}{Stress tolerance.}\item{\code{STI}}{Stress tolerance index.}\item{\code{SSPI}}{Stress susceptibility percentage index.}\item{\code{YI}}{Yield index.}\item{\code{YSI}}{Yield stability index.}\item{\code{RSI}}{Relative
stress index.}\item{\code{MP}}{Mean productivity.}\item{\code{GMP}}{Geometric mean productivity}\item{\code{HMP}}{Harmonic mean.}\item{\code{MRP}}{Mean relative performance.}\item{\code{PYR}}{Percent yield Reduction.}
}
\description{
Estimation of Drought Tolerance Indices.
}
\details{
Estimation various Drought Tolerance Indices of genotypes evaluated under stress and non-stress conditions of both replicated and non-replicated data.
}
\note{
The function can handle both replicated and non-replicated data refer the examples.
}
\examples{
\dontrun{# Estimating drought tolerance indices
library(gpbStat)

data(datdti)
result1 =  dti(datdti, environment = ENV, genotype = GEN, datdti[,3:8],
              ns = 'NS-DWR', st = 'ST-DWR')
result1

data(datrdti)
result2 = dti(datrdti, environment = ENV, genotype = GEN, datrdti[,4:9],
            ns = 'NS-DWR', st = 'ST-DWR')
result2
}
}
\references{
Lamba, K., Kumar M., Singh V., Chaudhary L., Sharma R., Yashveer S. and Dalal, M. S. (2023). Heat stress tolerance indices for identification of the heat tolerant wheat genotypes.
           Scientific Reports, 13(1). https://doi.org/10.1038/s41598-023-37634-8
}
\seealso{
\code{\link[gpbStat]{ltc}, \link[gpbStat]{ltcchk}, \link[gpbStat]{ltcmt}}
}
\author{
Nandan Patil \email{tryanother609@gmail.com}
}
