% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_roads.R
\name{google_nearestRoads}
\alias{google_nearestRoads}
\title{Nearest Roads}
\usage{
google_nearestRoads(df_points, lat = NULL, lon = NULL, simplify = TRUE,
  curl_proxy = NULL, key = get_api_key("roads"))
}
\arguments{
\item{df_points}{\code{data.frame} with at least two columns specifying the latitude & longitude coordinates,
with a maximum of 100 pairs of coordinates.}

\item{lat}{string specifying the column of \code{df_path} containing the
'latitude' coordinates. If left NULL, a best-guess will be made}

\item{lon}{string specifying the column of \code{df_path} containing the
'longitude' coordinates. If left NULL, a best-guess will be made}

\item{simplify}{\code{logical} - TRUE indicates the returned JSON will be
coerced into a list. FALSE indicates the returend JSON will be returned as a string}

\item{curl_proxy}{a curl proxy object}

\item{key}{\code{string} A valid Google Developers Places API key}
}
\description{
Takes up to 100 independent coordinates and returns the closest road segment for each point.
The points passed do not need to be part of a continuous path.
}
\examples{
\dontrun{

key <- 'your_api_key'

df_points <- read.table(text = "lat lon
 60.1707 24.9426
 60.1708 24.9424
 60.1709 24.9423", header = T)

google_nearestRoads(df_points, key = key)

}
}
\seealso{
\link{google_snapToRoads}
}
