% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layers.R
\name{add_polylines}
\alias{add_polylines}
\title{Add polyline}
\usage{
add_polylines(map, data = get_map_data(map), polyline = NULL, lat = NULL,
  lon = NULL, id = NULL, geodesic = NULL, stroke_colour = NULL,
  stroke_weight = NULL, stroke_opacity = NULL, info_window = NULL,
  mouse_over = NULL, mouse_over_group = NULL, update_map_view = TRUE,
  layer_id = NULL, z_index = NULL)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing at least a \code{polyline} column, or a
\code{lat} and a \code{lon} column. If Null, the data passed into
\code{google_map()} will be used.}

\item{polyline}{string specifying the column of \code{data} containing the
encoded 'polyline'.}

\item{lat}{string specifying the column of \code{data} containing the 'latitude'
coordinates. Coordinates must be in the order that defines the path.}

\item{lon}{string specifying the column of \code{data} containing the 'longitude'
coordinates. Coordinates must be in the order that defines the path.}

\item{id}{string specifying the column containing an identifier for a polyline}

\item{geodesic}{logical}

\item{stroke_colour}{either a string specifying the column of \code{data}
containing the stroke colour of each circle, or a valid hexadecimal numeric
HTML style to be applied to all the circles}

\item{stroke_weight}{either a string specifying the column of \code{data}
containing the stroke weight of each circle, or a number indicating the width
of pixels in the line to be applied to all the circles}

\item{stroke_opacity}{either a string specifying the column of \code{data}
containing the stroke opacity of each circle, or a value between 0 and 1 that
will be applied to all the circles}

\item{info_window}{string specifying the column of data to display in an info
window when a polyline is clicked}

\item{mouse_over}{string specifying the column of data to display when the
mouse rolls over the polyline}

\item{mouse_over_group}{string specifying the column of data specifying which
groups of polylines to highlight on mouseover}

\item{update_map_view}{logical specifying if the map should re-centre according
to the polyline.}

\item{layer_id}{single value specifying an id for the layer.}

\item{z_index}{single value specifying where the polylines appear in the layering
of the map objects. Layers with a higher \code{z_index} appear on top of those with
a lower \code{z_index}. See details.}
}
\description{
Add a polyline to a google map
}
\details{
\code{z_index} values define the order in which objects appear on the map.
Those with a higher value appear on top of those with a lower value. The default
order of objects is (1 being underneath all other objects)

\itemize{
  \item{1. Polygon}
  \item{2. Rectangle}
  \item{3. Polyline}
  \item{4. Circle}
}

Markers are always the top layer
}
\note{
The lines can be generated by either using an encoded polyline, or by a
set of lat/lon coordinates.
You sould specify either the column containing an encoded polyline, OR the
lat / lon colulmns.

Using \code{update_map_view = TRUE} for multiple polylines may be slow, so it
may be more appropriate to set the view of the map using the location argument
of \code{google_map()}
}
\examples{
\dontrun{

## using lat/lon coordinates

map_key <- "your_api_key"

google_map(data = tram_route, key = map_key) \%>\%
  add_polylines(lat = "shape_pt_lat", lon = "shape_pt_lon")


## using encoded polyline and various colour / fill options
url <- 'https://raw.githubusercontent.com/plotly/datasets/master/2011_february_aa_flight_paths.csv'
flights <- read.csv(url)
flights$id <- seq_len(nrow(flights))


## encode the routes as polylines
lst <- lapply(unique(flights$id), function(x){
  lat = c(flights[flights["id"] == x, c("start_lat")], flights[flights["id"] == x, c("end_lat")])
  lon = c(flights[flights["id"] == x, c("start_lon")], flights[flights["id"] == x, c("end_lon")])
  data.frame(id = x, polyline = encode_pl(lat = lat, lon = lon))
})

flights <- merge(flights, do.call(rbind, lst), by = "id")

style <- map_styles()$night

google_map(key = map_key, style = style) \%>\%
  add_polylines(data = flights, polyline = "polyline", mouse_over_group = "airport1",
               stroke_weight = 1, stroke_opacity = 0.3, stroke_colour = "#ccffff")


}
}

