% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_drive_find.R
\name{team_drive_find}
\alias{team_drive_find}
\title{Find Team Drives}
\usage{
team_drive_find(pattern = NULL, n_max = Inf, ..., verbose = TRUE)
}
\arguments{
\item{pattern}{Character. If provided, only the items whose names match this
regular expression are returned. This is implemented locally on the results
returned by the API.}

\item{n_max}{Integer. An upper bound on the number of items to return. This
applies to the results requested from the API, which may be further
filtered locally, via the \code{pattern} argument.}

\item{...}{Other parameters to pass along in the request, such as \code{pageSize}.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
This is the closest googledrive function to what you get from
visiting \url{https://drive.google.com} and clicking "Team Drives".

Note: \href{https://gsuite.google.com/learning-center/products/drive/get-started-team-drive/}{Team Drives}
are only available to users of certain enhanced Google services, such as G
Suite Enterprise, G Suite Business, or G Suite for Education.
}
\examples{
\dontrun{
team_drive_find()
}
}
\seealso{
Wraps the \code{teamdrives.list} endpoint::
\itemize{
\item \url{https://developers.google.com/drive/v3/reference/teamdrives/list}
}
}
