% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpus.R
\name{gce_vm_gpu}
\alias{gce_vm_gpu}
\title{Launch a GPU enabled instance}
\usage{
gce_vm_gpu(...)
}
\arguments{
\item{...}{arguments passed to \link{gce_vm}}
}
\value{
A VM object
}
\description{
Helper function that fills in some defaults passed to \link{gce_vm}
}
\details{
If not specified, this function will enter defaults to get a GPU instance up and running.

\itemize{
  \item \code{use_beta: TRUE}
  \item \code{acceleratorCount: 1}
  \item \code{acceleratorType: "nvidia-tesla-k80"}
  \item \code{scheduling: list(onHostMaintenance = "terminate", automaticRestart = TRUE)}
  \item \code{image_project: "centos-cloud"}
  \item \code{image_family: "centos-7"}
  \item \code{predefined_type: "n1-standard-1"}
  \item \code{metadata: the contents of the the startup script in 
    system.file("startupscripts", "centos7cuda8.sh", package = "googleComputeEngineR")}
 }
}
\seealso{
Other GPU instances: \code{\link{gce_check_gpu}},
  \code{\link{gce_list_gpus}}
}
