% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudscheduler.R
\name{Job}
\alias{Job}
\title{Job Schedule Object}
\usage{
Job(
  name = NULL,
  description = NULL,
  schedule = NULL,
  timeZone = NULL,
  userUpdateTime = NULL,
  state = NULL,
  status = NULL,
  scheduleTime = NULL,
  lastAttemptTime = NULL,
  retryConfig = NULL,
  attemptDeadline = NULL,
  pubsubTarget = NULL,
  appEngineHttpTarget = NULL,
  httpTarget = NULL
)
}
\arguments{
\item{name}{Name to call your scheduled job}

\item{description}{Optionally caller-specified in CreateJob or}

\item{schedule}{A cron schedule e.g. \code{"15 5 * * *"}}

\item{timeZone}{Specifies the time zone to be used in interpreting schedule. If set to \code{NULL} will be "UTC". Note that some time zones include a provision for daylight savings time.}

\item{userUpdateTime}{Output only}

\item{state}{Output only}

\item{status}{Output only}

\item{scheduleTime}{Output only}

\item{lastAttemptTime}{Output only}

\item{retryConfig}{Settings that determine the retry behavior}

\item{attemptDeadline}{The deadline for job attempts}

\item{pubsubTarget}{A Pub/Sub target object \link{PubsubTarget} such as created via \link{cr_schedule_pubsub}}

\item{appEngineHttpTarget}{App Engine HTTP target}

\item{httpTarget}{A HTTP target object \link{HttpTarget}}
}
\value{
Job object
}
\description{
Job Schedule Object
}
\details{
Configuration for a job.The maximum allowed size for a job is 100KB.
}
\seealso{
Other Cloud Scheduler functions: 
\code{\link{HttpTarget}()},
\code{\link{PubsubTarget}()},
\code{\link{cr_build_schedule_http}()},
\code{\link{cr_run_schedule_http}()},
\code{\link{cr_schedule_delete}()},
\code{\link{cr_schedule_get}()},
\code{\link{cr_schedule_list}()},
\code{\link{cr_schedule_pause}()},
\code{\link{cr_schedule_run}()}
}
\concept{Cloud Scheduler functions}
