% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_wizard_auth.R
\name{gar_setup_auth_key}
\alias{gar_setup_auth_key}
\title{Create a service account for googleCloudRunner}
\usage{
gar_setup_auth_key(
  email = Sys.getenv("GARGLE_EMAIL"),
  file = "googleauthr-auth-key.json",
  session_user = NULL,
  client_json = "GAR_CLIENT_JSON",
  roles = NULL,
  default_key = "googleauthr"
)
}
\arguments{
\item{email}{What email to open OAuth2 with}

\item{file}{Where to save the authentication file}

\item{session_user}{1 for user level, 2 for project level, leave \code{NULL} to be prompted}

\item{client_json}{The location of the env arg holding client json}

\item{roles}{Whether to assign roles to the service key}

\item{default_key}{The default name of the service key}
}
\value{
TRUE if the file is ready to be setup, FALSE if need to stop
}
\description{
This will use your Google OAuth2 user to create a suitable service account
}
\seealso{
Other setup functions: 
\code{\link{gar_setup_auth_check}()},
\code{\link{gar_setup_clientid}()},
\code{\link{gar_setup_edit_renviron}()},
\code{\link{gar_setup_env_check}()},
\code{\link{gar_setup_menu_do}()},
\code{\link{gar_setup_menu}()}
}
\concept{setup functions}
