% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googleAuthR_shiny.R
\name{renderLogin}
\alias{renderLogin}
\title{Render a Google API Authentication Login/logout button}
\usage{
renderLogin(session, access_token, login_text = "Login via Google",
  logout_text = "Logout", login_class = "btn btn-primary",
  logout_class = "btn btn-default", access_type = c("online", "offline"),
  approval_prompt = c("auto", "force"), revoke = FALSE)
}
\arguments{
\item{session}{A Shiny session object}

\item{access_token}{A token generated by \code{reactiveAccessToken}}

\item{login_text}{What the login text will read on the button}

\item{logout_text}{What the logout text will read on the button}

\item{login_class}{The Bootstrap class for the login link}

\item{logout_class}{The Bootstrap class for the logout link}

\item{access_type}{Online or offline access for the authentication URL.}

\item{approval_prompt}{Whether to show the consent screen on authentication.}

\item{revoke}{If TRUE a user on logout will need to re-authenticate.}
}
\value{
An object to assign to output e.g. output$login
}
\description{
Use within a Shiny server.R to assign to an output for ui.R.
The login button carries an ActionLink with value "signed_in" 
  but as Shiny reloads on pushing it can't be used for detection of login state.  
  Use \code{!is.null(access_token())} instead.
}
\examples{
\dontrun{
## in global.R

## create the API call function, example with goo.gl URL shortner
library(googleAuthR)
options("googleAuthR.scopes.selected" = c("https://www.googleapis.com/auth/urlshortener"))

shorten_url <- function(url){

  body = list(
    longUrl = url
 )
 
 f <- gar_api_generator("https://www.googleapis.com/urlshortener/v1/url",
                        "POST",
                        data_parse_function = function(x) x$id)
                        
 f(the_body = body)
 
 }


## in server.R
library(shiny)
library(googleAuthR)
source('global.R')

shinyServer(function(input, output, session)){
  
  ## Get auth code from return URL
  access_token  <- reactiveAccessToken(session)

  ## Make a loginButton to display using loginOutput
  ## revoke=TRUE means upon logout a user will need to reauthenticate
  output$loginButton <- renderLogin(session, access_token(), revoke=TRUE)
  
  ## Needed if revoke=TRUE above
  revokeEventObserver(access_token())

  short_url_output <- eventReactive(input$submit, {
  ## wrap existing function with_shiny
  ## pass the reactive token in shiny_access_token
  ## pass other named arguments
    short_url <- with_shiny(f = shorten_url, 
                           shiny_access_token = access_token(),
                           url=input$url)
                           
   })
   
   output$short_url <- renderText({
   
     short_url_output()
     
   })
 }

## in ui.R
library(shiny)
library(googleAuthR)

shinyUI(
  fluidPage(
    loginOutput("loginButton"),
    textInput("url", "Enter URL"),
    actionButton("submit", "Shorten URL"),
    textOutput("short_url")
    ))
}
}
\seealso{
\link{revokeEventObserver}

Other shiny auth functions: \code{\link{authReturnCode}},
  \code{\link{createCode}},
  \code{\link{gar_shiny_getAuthUrl}},
  \code{\link{gar_shiny_getToken}},
  \code{\link{gar_shiny_getUrl}},
  \code{\link{loginOutput}},
  \code{\link{reactiveAccessToken}},
  \code{\link{revokeEventObserver}},
  \code{\link{with_shiny}}
}

