% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_dims_mets.R
\name{ga_custom_vars_list}
\alias{ga_custom_vars_list}
\title{List Custom Dimensions or Metrics}
\usage{
ga_custom_vars_list(accountId, webPropertyId,
  type = c("customDimensions", "customMetrics"))
}
\arguments{
\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id}

\item{type}{A customMetric or customDimension}
}
\value{
Custom Metric or Dimension List
}
\description{
List Custom Dimensions or Metrics
}
\details{
This function lists all the existing custom dimensions or metrics for the web property.
}
\examples{

\dontrun{
library(googleAnalyticsR)
ga_auth()

ga_custom_vars_list(54019251, webPropertyId = "UA-54019251-4", type = "customDimensions")

ga_custom_vars_list(54019251, webPropertyId = "UA-54019251-4", type = "customMetrics")

}
}
\seealso{
Other custom variable functions: \code{\link{ga_custom_vars_create}},
  \code{\link{ga_custom_vars_patch}},
  \code{\link{ga_custom_vars}}
}
\concept{custom variable functions}
