% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{ga_auth}
\alias{ga_auth}
\title{Authenticate with Google Analytics OAuth2}
\usage{
ga_auth(new_user = FALSE, no_auto = FALSE)
}
\arguments{
\item{new_user}{If TRUE, reauthenticate via Google login screen}

\item{no_auto}{Skip auto authentication}
}
\value{
Invisibly, the token that has been saved to the session
}
\description{
A wrapper for \link[googleAuthR]{gar_auth} and \link[googleAuthR]{gar_auth_service}
}
\details{
Run this function first time to authenticate with Google in your browser.  

After initial authentication, a \code{.httr-oauth} will be saved to your working directory, where your authentication details are kept.  Keep this file safe.

If you want to reauthenticate, delete this file from your directory or run \code{ga_auth(new_user = TRUE)}
}
\section{Auto-authentication}{


You can choose to auto-authenticate by moving your \code{.httr-oauth} or by 
  creating a Google OAuth service account JSON file.

Specify an environment variable in R via a \code{.Renviron} file or using \link{Sys.setenv} which point to the file location of your chosen authentication file.

Once you have set the environment variable \code{GA_AUTH_FILE} to a valid file location,
  the function will look there for authentication details upon loading the library meaning 
  you will not need to call \code{ga_auth()} yourself as you would normally.

An example \code{.Renviron} file is below:

\code{GA_AUTH_FILE = "/Users/bob/auth/googleAnalyticsR.httr-oauth"}

\code{GA_AUTH_FILE} can be either a token generated by \link[googleAuthR]{gar_auth} or
  service account JSON ending with file extension \code{.json}
  
If you use the service account JSON, you will need to add the service account email 
  to your Google Analytics users to see data e.g. \code{xxxx@yyyyyy.iam.gserviceaccount.com}
}

