% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_documents.R
\name{select_documents}
\alias{select_documents}
\title{Select Documents rom a TermDocumentMatrix/DocumentTermMatrix}
\usage{
select_documents(x, pattern, invert = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link[tm]{TermDocumentMatrix}} or \code{\link[tm]{DocumentTermMatrix}}.}

\item{pattern}{A regex pattern used to select documents.}

\item{invert}{logical.  If \code{TRUE} the pattern is inverted to exclude
these documents.}

\item{\ldots}{Other arguments passed to \code{\link[base]{grepl}}
(\code{perl = TRUE} is hard coded).}
}
\value{
Returns a \code{\link[tm]{TermDocumentMatrix}} or \code{\link[tm]{DocumentTermMatrix}}.
}
\description{
Select documents from a \code{\link[tm]{TermDocumentMatrix}}
or \code{\link[tm]{DocumentTermMatrix}} matching a regular expression.
}
\examples{
(x <-with(presidential_debates_2012, q_dtm(dialogue, paste(time, person, sep = "_"))))
select_documents(x, 'romney', ignore.case=TRUE)
select_documents(x, '^(?!.*romney).*$', ignore.case = TRUE)      # regex way to invert
select_documents(x, 'romney', ignore.case = TRUE, invert = TRUE) # easier way to invert
(y <- with(presidential_debates_2012, q_tdm(dialogue, paste(time, person, sep = "_"))))
select_documents(y, '[2-3]')
}
