% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wn_to_wv}
\alias{wn_to_wv}
\title{White Noise to WV}
\usage{
wn_to_wv(sig2, tau)
}
\arguments{
\item{sig2}{A \code{double} corresponding to variance of WN}

\item{tau}{A \code{vec} containing the scales e.g. 2^tau}
}
\value{
A \code{vec} containing the wavelet variance of the white noise.
}
\description{
This function compute the WV (haar) of a White Noise process
}
\examples{
x.sim = cumsum(rnorm(100000))
ntau = floor(log(length(x.sim),2))
tau = 2^(1:ntau)
wv.theo = wn_to_wv(1, tau)
plot(tau, wv.theo, col = "red")
}

