% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imu.R
\name{plot.wvar.imu}
\alias{plot.wvar.imu}
\title{Wrapper Function to Plot the Wavelet Variances of IMU Object}
\usage{
\method{plot}{wvar.imu}(x, split = TRUE, CI = TRUE, background = "white",
  transparence = 0.1, line.color = NULL, line.type = NULL,
  point.size = NULL, point.shape = NULL, CI.color = NULL,
  title = "Haar Wavelet Variance Representation", title.size = 15,
  axis.label.size = 13, axis.tick.size = 11,
  axis.x.label = expression(paste("Scale ", tau)),
  axis.y.label = expression(paste("Wavelet Variance ", nu)),
  facet.label.size = 13, facet.label.background = "#003C7D33",
  legend.title = "Axis", legend.key.size = 1.3, legend.title.size = 13,
  legend.text.size = 13, scales = "free_y", ...)
}
\arguments{
\item{x}{A \code{wvar.imu} object.}

\item{split}{A \code{boolean} that indicates whether the graphs should be separate (TRUE) or graphed ontop of each other (FALSE).}

\item{CI}{A \code{boolean} that indicates whether the confidence interval should be plotted.}

\item{background}{A \code{string} that determines the graph background. It can be \code{'grey'} or \code{'white'}.}

\item{transparence}{A \code{double} that ranges from 0 to 1 that controls the transparency of the confidence interval.}

\item{line.color}{A \code{vector} of \code{string} that indicates the color of the line drawn (e.g. black, blue, red, etc.)}

\item{line.type}{A \code{vector} of \code{string} that indicates the type of line (e.g. solid, dotted, etc.)}

\item{point.size}{A \code{vector} of \code{integer} that indicates the size of points on lines.}

\item{point.shape}{A \code{vector} of \code{integer} that indicates the shape of points on lines.}

\item{CI.color}{A \code{string} that indicates the color of the confidence interval (e.g. black, red, #003C7D, etc.)}

\item{title}{A \code{string} that indicates the title of the graph.}

\item{title.size}{An \code{integer} that indicates the size of title.}

\item{axis.label.size}{An \code{integer} that indicates the size of label.}

\item{axis.tick.size}{An \code{integer} that indicates the size of tick mark.}

\item{axis.x.label}{A \code{string} that indicates the label on x axis.}

\item{axis.y.label}{A \code{string} that indicates the label on y axis.}

\item{facet.label.size}{An \code{integer} that indicates the size of facet label.}

\item{facet.label.background}{A \code{string} that indicates the background color of the facet label.}

\item{legend.title}{A \code{string} that indicates the title of legend. It is onlly used when \code{split = FALSE}.}

\item{legend.key.size}{A \code{double} that indicates the size of key (in centermeters) on legend. It is onlly used when \code{split = FALSE}.}

\item{legend.title.size}{An \code{integer} that indicates the size of title on legend. It is onlly used when \code{split = FALSE}.}

\item{legend.text.size}{An \code{integer} that indicates the size of key label on legend. It is onlly used when \code{split = FALSE}.}

\item{scales}{Same as \code{scales} in \code{facet_grid()} in \code{ggplot2} package: should scales be fixed ("fixed"), free ("free"), or free in one dimension ("free_x", "free_y"). The default is "free_y" in this function.}

\item{...}{Additional options.}
}
\value{
A panel containing the graph of an IMU sensor.
}
\description{
Creates a graph of the wavelet variance for imu object.
}
\examples{
\dontrun{
if(!require("imudata")){
   install_imudata()
   library("imudata")
}

data(imu6)
test = imu(imu6, gyros = 1:3, accels = 4:6, freq = 100)
df = wvar.imu(test)

## Plot in split way
plot(df, split = T)
plot(df, split = T, CI = F)
plot(df, split = T, CI = T, line.color = c('black', 'black'), title.size = 18)

## Plot in combined way
plot(df, split = F)
plot(df, split = F, line.color = c('black', 'green', 'red'), CI.color = c('black', 'green', 'red'))
}
}

