% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wvar.R
\name{create_wvar}
\alias{create_wvar}
\title{Create a Wvar object}
\usage{
create_wvar(obj, decomp, robust, eff, alpha, scales, unit)
}
\arguments{
\item{obj}{A \code{matrix} with dimensions N x 3, that contains the wavelet variance, low ci, hi ci.}

\item{decomp}{A \code{string} that indicates whether to use the "dwt" or "modwt" decomposition}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}

\item{alpha}{A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level}

\item{scales}{A \code{vec} that contains the amount of decomposition done at each level.}

\item{unit}{A \code{string} that contains the unit expression of the frequency.}
}
\value{
A \code{list} with the structure:
\describe{
  \item{"variance"}{Wavelet Variance}
  \item{"ci_low"}{Lower CI}
  \item{"ci_high"}{Upper CI}
  \item{"robust"}{Robust active}
  \item{"eff"}{Efficiency level for Robust}
  \item{"alpha"}{p value used for CI}
  \item{"unit"}{String representation of the unit}
}
}
\description{
Structures elements into a WVar object
}
\keyword{internal}

