% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gts.R
\name{gen.gts}
\alias{gen.gts}
\title{Create a GMWM TS Object based on model}
\usage{
gen.gts(model, N = 1000, freq = 1, unit = NULL, name = "")
}
\arguments{
\item{model}{A \code{ts.model} or \code{gmwm} object containing one of the allowed models.}

\item{N}{An \code{interger} containing the amount of observations for the time series.}

\item{freq}{A \code{numeric} that provides the rate of samples. Default value is 1.}

\item{unit}{A \code{string} that contains the unit expression of the frequency. Default value is \code{NULL}.}

\item{name}{A \code{string} that provides an identifier to the data. Default value is an empty string.}
}
\value{
A \code{gts} object with the structure:
\itemize{
  \item{x:} {A \code{matirx} that contains x-axis values to plot}
  \item{data:} {A \code{matrix} that contains data for combined processes}
  \item{freq:} {Numeric representation of frequency}
  \item{unit:} {String representation of the unit}
  \item{name:} {Name of the Dataset}
}
}
\description{
Create a \code{gts} object based on a supplied time series model.
}
\details{
This function accepts either a \code{ts.model} object (e.g. AR1(phi = .3, sigma2 =1) + WN(sigma2 = 1)) or a \code{gmwm} object.
}
\examples{
# AR
set.seed(1336)
model = AR1(phi = .99, sigma = 1) + WN(sigma2=1)
gen.gts(model)
}

