% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardErrors.R
\name{print_std_errors}
\alias{print_std_errors}
\title{Print standard errors of GMVAR model in the same form as the model estimates are printed}
\usage{
print_std_errors(gmvar, digits = 3)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{digits}{how many digits should be printed?}
}
\description{
\code{print_std_errors} prints the approximate standard errors of GMVAR model in the
  same form as the parameters of objects of class \code{'gmvar'} are printed.
}
\details{
The main purpose of \code{print_std_errors} is to provide a convenient tool to match the standard
  errors to certain parameter estimates. Note that if the model is intercept parametrized, there won't
  be standard errors for the unconditional means, and vice versa. Also, there is no standard error for the
  last mixing weight alpha_M because it is not parametrized.

  Note that if linear constraints are imposed and they involve summations or multiplications, then the AR
  parameter standard errors are printed separately as they don't correspond one-to-one to the model parameter
  standard errors.
}
\examples{
\donttest{
# GMVAR(1,2) model
fit12 <- fitGMVAR(gdpdef, p=1, M=2, ncalls=1, seeds=1)
fit12
print_std_errors(fit12)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{print.gmvar}},
 \code{\link{swap_parametrization}}
}
