% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMVARconstruction.R
\name{update_numtols}
\alias{update_numtols}
\title{Update the stationarity and positive definiteness numerical tolerances of an
  existing class 'gmvar' model.}
\usage{
update_numtols(gmvar, stat_tol = 0.001, posdef_tol = 1e-08)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{stat_tol}{numerical tolerance for stationarity of the AR parameters: if the "bold A" matrix of any regime
has eigenvalues larger that \code{1 - stat_tol} the model is classified as non-stationary. Note that if the
tolerance is too small, numerical evaluation of the log-likelihood might fail and cause error.}

\item{posdef_tol}{numerical tolerance for positive definiteness of the error term covariance matrices: if
the error term covariance matrix of any regime has eigenvalues smaller than this, the model is classified
as not satisfying positive definiteness assumption. Note that if the tolerance is too small, numerical
evaluation of the log-likelihood might fail and cause error.}
}
\value{
Returns an object of class \code{'gmvar'} defining a structural GMVAR model with the modified
  structural parameters and constraints.
}
\description{
\code{update_numtols} updates the stationarity and positive definiteness
  numerical tolerances of an existing class 'gmvar' model.
}
\details{
All signs in any column of \eqn{W} can be swapped without changing the implied reduced form model.
  Consequently, also the signs in the columns of the B-matrix are swapped. Note that the sign constraints
  imposed on \eqn{W} (or the B-matrix) are also swapped in the corresponding columns accordingly.

  Also the order of the columns of \eqn{W} can be changed (without changing the implied reduced
  form model) as long as the order of lambda parameters is also changed accordingly. This can be
  done with the function \code{reorder_W_columns}.
}
\examples{
# Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
params222s <- c(-11.964, 155.024, 11.636, 124.988, 1.314, 0.145, 0.094, 1.292,
 -0.389, -0.07, -0.109, -0.281, 1.248, 0.077, -0.04, 1.266, -0.272, -0.074,
  0.034, -0.313, 0.903, 0.718, -0.324, 2.079, 7.00, 1.44, 0.742)
W_222 <- matrix(c(1, 1, -1, 1), nrow=2, byrow=FALSE)
mod222s <- GMVAR(p=2, M=2, d=2, params=params222s, parametrization="mean",
                 structural_pars=list(W=W_222))
mod222s

# Update numerical tolerances:
mod222s <- update_numtols(mod222s, stat_tol=1e-4, posdef_tol=1e-9)
mod222s
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{gmvar_to_sgmvar}}
}
