% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{get_minval}
\alias{get_minval}
\title{Returns the default smallest allowed log-likelihood for given data.}
\usage{
get_minval(data)
}
\arguments{
\item{data}{a matrix or class \code{'ts'} object with \code{d>1} columns. Each column is taken to represent
a single time series. \code{NA} values are not supported.}
}
\value{
Returns \code{-(10^(ceiling(log10(nrow(data)) + ncol(data))) - 1)}
}
\description{
\code{get_minval} returns the default smallest allowed log-likelihood for given data.
}
\details{
This function exists to avoid dublication inside the package.
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GAfit}}
}
