% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{random_coefmats2}
\alias{random_coefmats2}
\title{Create somewhat random stationary VAR model \eqn{(dxd)}
 coefficient matrices \eqn{A}.}
\usage{
random_coefmats2(p, d, ar_scale = 1)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive degree of the model.}

\item{d}{number of time series in the system.}

\item{ar_scale}{a positive real number. Larger values will likely result larger AR-coefficients.}
}
\value{
Returns \eqn{((pd^2)x1)} vector containing stationary vectorized coefficient
 matrices \eqn{(vec(A_{1}),...,vec(A_{p})}.
}
\description{
\code{random_coefmats2} generates random VAR model coefficientmatrices
}
\details{
The coefficient matrices are generated using the algorithm described by Ansley
  and Kohn (1986), which forces stationarity. It's not clear in detail how \code{ar_scale}
  affects the coefficient matrices. Read the cited article by Ansley and Kohn (1986) AND
  the source code for more information.
}
\references{
\itemize{
   \item Ansley C.F., Kohn R. 1986. A note on reparameterizing a vector autoregressive
      moving average model to enforce stationarity.
      \emph{Journal of statistical computation and simulation}, \strong{24}:2,  99-106.
 }
}
