% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_constant.R
\name{show_constant}
\alias{show_constant}
\title{Show constant columns}
\usage{
show_constant(oTree, value = "any")
}
\arguments{
\item{oTree}{A list of data frames that were created by import_otree().}

\item{value}{The value that is controlled to be the same within a column.
The default is NA. If the value is set to "any," the function checks for
columns where any possible values are identical.}
}
\value{
This function returns a list of vectors, one for each app,
all_apps_wide, the Time and/or the Chats data frame.
Each vector contains the names of all variables with constant values.
If there are no variables with constant values, the vector is empty.
}
\description{
Show all columns with no variation in their values for each data frame
in the oTree list of data frames (except the ones in the info list).
This function is helpful before running an experiment to check if there
are unnecessary variables.
You can check for columns that have any unchanging possible value
or for columns containing only a specific value.
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Show all columns that contain only NAs
show_constant(oTree = oTree)
show_constant(oTree = oTree, value = NA)

# Show all columns that contain only -99
show_constant(oTree = oTree, value = -99)
}
\keyword{oTree}
